using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Web.Services;
using System.Web.Services.Discovery;

namespace WindowsApplication1
{
   public partial class Form1 : Form
   {
//      private Button button1;
//      private TextBox txtDiscoverUrl;
//      private ListView listView1;
//      private ListView listView2;
      private DiscoveryDocument doc = null;

      public Form1()
      {
         InitializeComponent();
      }

      private void button1_Click(object sender, EventArgs e)
      {
         DiscoveryClientProtocol discoClient = new DiscoveryClientProtocol();
         discoClient.Credentials = System.Net.CredentialCache.DefaultCredentials;
         doc = discoClient.DiscoverAny(txtDiscoverUrl.Text);
         listView1.Items.Clear();
         listView2.Items.Clear();

         foreach (object discoRef in doc.References)
         {
            ListViewItem lvi = new ListViewItem();
            // referencja kontraktu
            if (discoRef is ContractReference)
            {
               ContractReference cRef = (ContractReference)discoRef;
               lvi.Text = cRef.DefaultFilename;
               lvi.SubItems.Add(cRef.Url);
               listView1.Items.Add(lvi);
            }
            else if (discoRef is SoapBinding)
            {
               SoapBinding sb = (SoapBinding)discoRef;
               lvi.Text = sb.Address.ToString();
               lvi.SubItems.Add(sb.Binding.Name);
               listView2.Items.Add(lvi);
            }
         }
      }

      private void button2_Click(object sender, EventArgs e)
      {
         localhost.SoapHeaderTest svc = new localhost.SoapHeaderTest();
         svc.TestSoapHeaderValue = new localhost.TestSoapHeader();
         svc.TestSoapHeaderValue.FirstValue = "jeden";
         svc.TestSoapHeaderValue.SecondValue = "dwa";
         string output = svc.HeaderEnabledMethod("Witaj wiecie");
         output = string.Format("Komunikat otrzymany z usugi: {0}\nNagwek: {1} / {2}\n",
           output, svc.TestSoapHeaderValue.FirstValue,
           svc.TestSoapHeaderValue.SecondValue);
         MessageBox.Show(output);
      }

   }
}
